#!/bin/bash

echo $1

diskP1=p1
diskP2=p2

if [[ $1 = "-h" || $1 = "-H" ]]; then
	echo "===========虚拟磁盘使用说明==========="
	echo "参数一：命令字，C-创建磁盘 D-删除磁盘 F-格式化磁盘 S-烧写固件 H-帮助"
	echo "参数二：硬盘大小，单位MB，最小硬盘1MB"
	echo "参数三：硬盘名称，自定义"
	echo "======================================"
	exit 1

else
	if [[ -z "$1" || -z "$2" || -z "$3" ]]; then
        	echo "请输入有效的参数！"
        	exit 1
	elif [[ $1 = "-c" || $1 = "-C" ]]; then
		echo "开始创建虚拟磁盘！"
		dd if=/dev/zero of=$3 bs=1M count=$2
		# 非交互式执行 fdisk 命令
		# 这里的逻辑是：n(新建分区) -> p(主分区) -> 1(分区号) -> 回车(默认起始扇区) -> +10G(大小) -> w(保存)
		echo -e "n\np\n1\n\n+200M\nn\np\n\n\n\nw" | fdisk $3
		echo "创建磁盘完成！"
	elif [[ $1 = "-d" || $1 = "-D" ]]; then
		echo "开始删除虚拟磁盘！"
		sudo rm -rf $3

		echo "删除完成！"

	elif [[ $1 = "-f" || $1 = "-F" ]]; then
		echo "开始格式化虚拟磁盘！"
		sudo losetup -fP $3
		varInfo=$(losetup -l | grep $3)
		varInfo=(${varInfo//,/ })
		echo ${varInfo}

		sudo mkfs.fat ${varInfo}${diskP1}
		sudo mkfs.ext4 ${varInfo}${diskP2}

		sudo losetup -d $varInfo
		echo "格式化完成！"

	elif [[ $1 = "-s" || $1 = "-S" ]]; then
		echo "开始烧写固件！"
		sudo losetup -fP $3
		varInfo=$(losetup -l | grep $3)
                varInfo=(${varInfo//,/ })
                echo ${varInfo}
		sleep 1

		sudo mount ${varInfo}${diskP1} /mnt
		sudo cp Image s5000c-64c.dtb /mnt
		sync
		sudo umount /mnt
		sudo umount /mnt
		sleep 1

		sudo mount ${varInfo}${diskP2} /mnt
		sudo cp rootfs.tar /mnt
	        cd /mnt
		sudo tar -xvf rootfs.tar
		
		sleep 1	

		sync
		  
		sleep 5
		cd /
		sudo umount /mnt
		
		sudo umount /mnt
		sleep 1

		sudo losetup -d $varInfo
		echo "烧写完成！"

	fi


fi
